/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest;

public class UpdateServerCertificateRequestMarshaller
implements Marshaller<Request<UpdateServerCertificateRequest>, UpdateServerCertificateRequest> {
    public Request<UpdateServerCertificateRequest> marshall(UpdateServerCertificateRequest updateServerCertificateRequest) {
        if (updateServerCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateServerCertificateRequest, "IAMClient");
        request.addParameter("Action", "UpdateServerCertificate");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateServerCertificateRequest.serverCertificateName() != null) {
            request.addParameter("ServerCertificateName", StringUtils.fromString((String)updateServerCertificateRequest.serverCertificateName()));
        }
        if (updateServerCertificateRequest.newPath() != null) {
            request.addParameter("NewPath", StringUtils.fromString((String)updateServerCertificateRequest.newPath()));
        }
        if (updateServerCertificateRequest.newServerCertificateName() != null) {
            request.addParameter("NewServerCertificateName", StringUtils.fromString((String)updateServerCertificateRequest.newServerCertificateName()));
        }
        return request;
    }
}

