/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;

public class GetRolePolicyRequestMarshaller
implements Marshaller<Request<GetRolePolicyRequest>, GetRolePolicyRequest> {
    public Request<GetRolePolicyRequest> marshall(GetRolePolicyRequest getRolePolicyRequest) {
        if (getRolePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getRolePolicyRequest, "IAMClient");
        request.addParameter("Action", "GetRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)getRolePolicyRequest.roleName()));
        }
        if (getRolePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)getRolePolicyRequest.policyName()));
        }
        return request;
    }
}

