/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.EnableMFADeviceRequest;

public class EnableMFADeviceRequestMarshaller
implements Marshaller<Request<EnableMFADeviceRequest>, EnableMFADeviceRequest> {
    public Request<EnableMFADeviceRequest> marshall(EnableMFADeviceRequest enableMFADeviceRequest) {
        if (enableMFADeviceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableMFADeviceRequest, "IAMClient");
        request.addParameter("Action", "EnableMFADevice");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableMFADeviceRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)enableMFADeviceRequest.userName()));
        }
        if (enableMFADeviceRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString((String)enableMFADeviceRequest.serialNumber()));
        }
        if (enableMFADeviceRequest.authenticationCode1() != null) {
            request.addParameter("AuthenticationCode1", StringUtils.fromString((String)enableMFADeviceRequest.authenticationCode1()));
        }
        if (enableMFADeviceRequest.authenticationCode2() != null) {
            request.addParameter("AuthenticationCode2", StringUtils.fromString((String)enableMFADeviceRequest.authenticationCode2()));
        }
        return request;
    }
}

