/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.DeleteUserRequest;

public class DeleteUserRequestMarshaller
implements Marshaller<Request<DeleteUserRequest>, DeleteUserRequest> {
    public Request<DeleteUserRequest> marshall(DeleteUserRequest deleteUserRequest) {
        if (deleteUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteUserRequest, "IAMClient");
        request.addParameter("Action", "DeleteUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteUserRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)deleteUserRequest.userName()));
        }
        return request;
    }
}

