/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest;

public class CreateServiceLinkedRoleRequestMarshaller
implements Marshaller<Request<CreateServiceLinkedRoleRequest>, CreateServiceLinkedRoleRequest> {
    public Request<CreateServiceLinkedRoleRequest> marshall(CreateServiceLinkedRoleRequest createServiceLinkedRoleRequest) {
        if (createServiceLinkedRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createServiceLinkedRoleRequest, "IAMClient");
        request.addParameter("Action", "CreateServiceLinkedRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServiceLinkedRoleRequest.awsServiceName() != null) {
            request.addParameter("AWSServiceName", StringUtils.fromString((String)createServiceLinkedRoleRequest.awsServiceName()));
        }
        if (createServiceLinkedRoleRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createServiceLinkedRoleRequest.description()));
        }
        if (createServiceLinkedRoleRequest.customSuffix() != null) {
            request.addParameter("CustomSuffix", StringUtils.fromString((String)createServiceLinkedRoleRequest.customSuffix()));
        }
        return request;
    }
}

