/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest;

public class CreatePolicyVersionRequestMarshaller
implements Marshaller<Request<CreatePolicyVersionRequest>, CreatePolicyVersionRequest> {
    public Request<CreatePolicyVersionRequest> marshall(CreatePolicyVersionRequest createPolicyVersionRequest) {
        if (createPolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPolicyVersionRequest, "IAMClient");
        request.addParameter("Action", "CreatePolicyVersion");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPolicyVersionRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString((String)createPolicyVersionRequest.policyArn()));
        }
        if (createPolicyVersionRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createPolicyVersionRequest.policyDocument()));
        }
        if (createPolicyVersionRequest.setAsDefault() != null) {
            request.addParameter("SetAsDefault", StringUtils.fromBoolean((Boolean)createPolicyVersionRequest.setAsDefault()));
        }
        return request;
    }
}

