/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest;

public class CreateInstanceProfileRequestMarshaller
implements Marshaller<Request<CreateInstanceProfileRequest>, CreateInstanceProfileRequest> {
    public Request<CreateInstanceProfileRequest> marshall(CreateInstanceProfileRequest createInstanceProfileRequest) {
        if (createInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceProfileRequest, "IAMClient");
        request.addParameter("Action", "CreateInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceProfileRequest.instanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringUtils.fromString((String)createInstanceProfileRequest.instanceProfileName()));
        }
        if (createInstanceProfileRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createInstanceProfileRequest.path()));
        }
        return request;
    }
}

