/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SSHPublicKeyMetadata
implements ToCopyableBuilder<Builder, SSHPublicKeyMetadata> {
    private final String userName;
    private final String sshPublicKeyId;
    private final String status;
    private final Instant uploadDate;

    private SSHPublicKeyMetadata(BuilderImpl builder) {
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.status = builder.status;
        this.uploadDate = builder.uploadDate;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant uploadDate() {
        return this.uploadDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.sshPublicKeyId() == null ? 0 : this.sshPublicKeyId().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.uploadDate() == null ? 0 : this.uploadDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSHPublicKeyMetadata)) {
            return false;
        }
        SSHPublicKeyMetadata other = (SSHPublicKeyMetadata)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.sshPublicKeyId() == null ^ this.sshPublicKeyId() == null) {
            return false;
        }
        if (other.sshPublicKeyId() != null && !other.sshPublicKeyId().equals(this.sshPublicKeyId())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.uploadDate() == null ^ this.uploadDate() == null) {
            return false;
        }
        return other.uploadDate() == null || other.uploadDate().equals(this.uploadDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.sshPublicKeyId() != null) {
            sb.append("SSHPublicKeyId: ").append(this.sshPublicKeyId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.uploadDate() != null) {
            sb.append("UploadDate: ").append(this.uploadDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyId": {
                return Optional.of(clazz.cast(this.sshPublicKeyId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "UploadDate": {
                return Optional.of(clazz.cast(this.uploadDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;
        private String status;
        private Instant uploadDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SSHPublicKeyMetadata model) {
            this.userName(model.userName);
            this.sshPublicKeyId(model.sshPublicKeyId);
            this.status(model.status);
            this.uploadDate(model.uploadDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSSHPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public SSHPublicKeyMetadata build() {
            return new SSHPublicKeyMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SSHPublicKeyMetadata> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder uploadDate(Instant var1);
    }
}

