/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SAMLProviderListEntry
implements ToCopyableBuilder<Builder, SAMLProviderListEntry> {
    private final String arn;
    private final Instant validUntil;
    private final Instant createDate;

    private SAMLProviderListEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.validUntil = builder.validUntil;
        this.createDate = builder.createDate;
    }

    public String arn() {
        return this.arn;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.validUntil() == null ? 0 : this.validUntil().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAMLProviderListEntry)) {
            return false;
        }
        SAMLProviderListEntry other = (SAMLProviderListEntry)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.validUntil() == null ^ this.validUntil() == null) {
            return false;
        }
        if (other.validUntil() != null && !other.validUntil().equals(this.validUntil())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        return other.createDate() == null || other.createDate().equals(this.createDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.validUntil() != null) {
            sb.append("ValidUntil: ").append(this.validUntil()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "ValidUntil": {
                return Optional.of(clazz.cast(this.validUntil()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant validUntil;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SAMLProviderListEntry model) {
            this.arn(model.arn);
            this.validUntil(model.validUntil);
            this.createDate(model.createDate);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public SAMLProviderListEntry build() {
            return new SAMLProviderListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SAMLProviderListEntry> {
        public Builder arn(String var1);

        public Builder validUntil(Instant var1);

        public Builder createDate(Instant var1);
    }
}

