/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyVersion
implements ToCopyableBuilder<Builder, PolicyVersion> {
    private final String document;
    private final String versionId;
    private final Boolean isDefaultVersion;
    private final Instant createDate;

    private PolicyVersion(BuilderImpl builder) {
        this.document = builder.document;
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.createDate = builder.createDate;
    }

    public String document() {
        return this.document;
    }

    public String versionId() {
        return this.versionId;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.document() == null ? 0 : this.document().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.isDefaultVersion() == null ? 0 : this.isDefaultVersion().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersion)) {
            return false;
        }
        PolicyVersion other = (PolicyVersion)obj;
        if (other.document() == null ^ this.document() == null) {
            return false;
        }
        if (other.document() != null && !other.document().equals(this.document())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.isDefaultVersion() == null ^ this.isDefaultVersion() == null) {
            return false;
        }
        if (other.isDefaultVersion() != null && !other.isDefaultVersion().equals(this.isDefaultVersion())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        return other.createDate() == null || other.createDate().equals(this.createDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.document() != null) {
            sb.append("Document: ").append(this.document()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.isDefaultVersion() != null) {
            sb.append("IsDefaultVersion: ").append(this.isDefaultVersion()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.of(clazz.cast(this.document()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "IsDefaultVersion": {
                return Optional.of(clazz.cast(this.isDefaultVersion()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String document;
        private String versionId;
        private Boolean isDefaultVersion;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersion model) {
            this.document(model.document);
            this.versionId(model.versionId);
            this.isDefaultVersion(model.isDefaultVersion);
            this.createDate(model.createDate);
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public PolicyVersion build() {
            return new PolicyVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyVersion> {
        public Builder document(String var1);

        public Builder versionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder createDate(Instant var1);
    }
}

