/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model._groupListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGroupsForUserResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListGroupsForUserResponse> {
    private final List<Group> groups;
    private final Boolean isTruncated;
    private final String marker;

    private ListGroupsForUserResponse(BuilderImpl builder) {
        this.groups = builder.groups;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<Group> groups() {
        return this.groups;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsForUserResponse)) {
            return false;
        }
        ListGroupsForUserResponse other = (ListGroupsForUserResponse)((Object)obj);
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Group> groups;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsForUserResponse model) {
            this.groups(model.groups);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<Group.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(Group::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<Group> groups) {
            this.groups = _groupListTypeCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Group ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<Group.BuilderImpl> groups) {
            this.groups = _groupListTypeCopier.copyFromBuilder(groups);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListGroupsForUserResponse build() {
            return new ListGroupsForUserResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListGroupsForUserResponse> {
        public Builder groups(Collection<Group> var1);

        public Builder groups(Group ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

