/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model.EncodingType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSSHPublicKeyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetSSHPublicKeyRequest> {
    private final String userName;
    private final String sshPublicKeyId;
    private final String encoding;

    private GetSSHPublicKeyRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.encoding = builder.encoding;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public EncodingType encoding() {
        return EncodingType.fromValue(this.encoding);
    }

    public String encodingString() {
        return this.encoding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.sshPublicKeyId() == null ? 0 : this.sshPublicKeyId().hashCode());
        hashCode = 31 * hashCode + (this.encodingString() == null ? 0 : this.encodingString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSSHPublicKeyRequest)) {
            return false;
        }
        GetSSHPublicKeyRequest other = (GetSSHPublicKeyRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.sshPublicKeyId() == null ^ this.sshPublicKeyId() == null) {
            return false;
        }
        if (other.sshPublicKeyId() != null && !other.sshPublicKeyId().equals(this.sshPublicKeyId())) {
            return false;
        }
        if (other.encodingString() == null ^ this.encodingString() == null) {
            return false;
        }
        return other.encodingString() == null || other.encodingString().equals(this.encodingString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.sshPublicKeyId() != null) {
            sb.append("SSHPublicKeyId: ").append(this.sshPublicKeyId()).append(",");
        }
        if (this.encodingString() != null) {
            sb.append("Encoding: ").append(this.encodingString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyId": {
                return Optional.of(clazz.cast(this.sshPublicKeyId()));
            }
            case "Encoding": {
                return Optional.of(clazz.cast(this.encodingString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;
        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSSHPublicKeyRequest model) {
            this.userName(model.userName);
            this.sshPublicKeyId(model.sshPublicKeyId);
            this.encoding(model.encoding);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSSHPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(EncodingType encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public GetSSHPublicKeyRequest build() {
            return new GetSSHPublicKeyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetSSHPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder encoding(String var1);

        public Builder encoding(EncodingType var1);
    }
}

