/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.ContextKeyTypeEnum;
import software.amazon.awssdk.services.iam.model.ContextKeyValueListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContextEntry
implements ToCopyableBuilder<Builder, ContextEntry> {
    private final String contextKeyName;
    private final List<String> contextKeyValues;
    private final String contextKeyType;

    private ContextEntry(BuilderImpl builder) {
        this.contextKeyName = builder.contextKeyName;
        this.contextKeyValues = builder.contextKeyValues;
        this.contextKeyType = builder.contextKeyType;
    }

    public String contextKeyName() {
        return this.contextKeyName;
    }

    public List<String> contextKeyValues() {
        return this.contextKeyValues;
    }

    public ContextKeyTypeEnum contextKeyType() {
        return ContextKeyTypeEnum.fromValue(this.contextKeyType);
    }

    public String contextKeyTypeString() {
        return this.contextKeyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.contextKeyName() == null ? 0 : this.contextKeyName().hashCode());
        hashCode = 31 * hashCode + (this.contextKeyValues() == null ? 0 : this.contextKeyValues().hashCode());
        hashCode = 31 * hashCode + (this.contextKeyTypeString() == null ? 0 : this.contextKeyTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextEntry)) {
            return false;
        }
        ContextEntry other = (ContextEntry)obj;
        if (other.contextKeyName() == null ^ this.contextKeyName() == null) {
            return false;
        }
        if (other.contextKeyName() != null && !other.contextKeyName().equals(this.contextKeyName())) {
            return false;
        }
        if (other.contextKeyValues() == null ^ this.contextKeyValues() == null) {
            return false;
        }
        if (other.contextKeyValues() != null && !other.contextKeyValues().equals(this.contextKeyValues())) {
            return false;
        }
        if (other.contextKeyTypeString() == null ^ this.contextKeyTypeString() == null) {
            return false;
        }
        return other.contextKeyTypeString() == null || other.contextKeyTypeString().equals(this.contextKeyTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.contextKeyName() != null) {
            sb.append("ContextKeyName: ").append(this.contextKeyName()).append(",");
        }
        if (this.contextKeyValues() != null) {
            sb.append("ContextKeyValues: ").append(this.contextKeyValues()).append(",");
        }
        if (this.contextKeyTypeString() != null) {
            sb.append("ContextKeyType: ").append(this.contextKeyTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContextKeyName": {
                return Optional.of(clazz.cast(this.contextKeyName()));
            }
            case "ContextKeyValues": {
                return Optional.of(clazz.cast(this.contextKeyValues()));
            }
            case "ContextKeyType": {
                return Optional.of(clazz.cast(this.contextKeyTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String contextKeyName;
        private List<String> contextKeyValues;
        private String contextKeyType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextEntry model) {
            this.contextKeyName(model.contextKeyName);
            this.contextKeyValues(model.contextKeyValues);
            this.contextKeyType(model.contextKeyType);
        }

        public final String getContextKeyName() {
            return this.contextKeyName;
        }

        @Override
        public final Builder contextKeyName(String contextKeyName) {
            this.contextKeyName = contextKeyName;
            return this;
        }

        public final void setContextKeyName(String contextKeyName) {
            this.contextKeyName = contextKeyName;
        }

        public final Collection<String> getContextKeyValues() {
            return this.contextKeyValues;
        }

        @Override
        public final Builder contextKeyValues(Collection<String> contextKeyValues) {
            this.contextKeyValues = ContextKeyValueListTypeCopier.copy(contextKeyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeyValues(String ... contextKeyValues) {
            this.contextKeyValues(Arrays.asList(contextKeyValues));
            return this;
        }

        public final void setContextKeyValues(Collection<String> contextKeyValues) {
            this.contextKeyValues = ContextKeyValueListTypeCopier.copy(contextKeyValues);
        }

        public final String getContextKeyType() {
            return this.contextKeyType;
        }

        @Override
        public final Builder contextKeyType(String contextKeyType) {
            this.contextKeyType = contextKeyType;
            return this;
        }

        @Override
        public final Builder contextKeyType(ContextKeyTypeEnum contextKeyType) {
            this.contextKeyType(contextKeyType.toString());
            return this;
        }

        public final void setContextKeyType(String contextKeyType) {
            this.contextKeyType = contextKeyType;
        }

        public ContextEntry build() {
            return new ContextEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContextEntry> {
        public Builder contextKeyName(String var1);

        public Builder contextKeyValues(Collection<String> var1);

        public Builder contextKeyValues(String ... var1);

        public Builder contextKeyType(String var1);

        public Builder contextKeyType(ContextKeyTypeEnum var1);
    }
}

