/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccessKeyLastUsed
implements ToCopyableBuilder<Builder, AccessKeyLastUsed> {
    private final Instant lastUsedDate;
    private final String serviceName;
    private final String region;

    private AccessKeyLastUsed(BuilderImpl builder) {
        this.lastUsedDate = builder.lastUsedDate;
        this.serviceName = builder.serviceName;
        this.region = builder.region;
    }

    public Instant lastUsedDate() {
        return this.lastUsedDate;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lastUsedDate() == null ? 0 : this.lastUsedDate().hashCode());
        hashCode = 31 * hashCode + (this.serviceName() == null ? 0 : this.serviceName().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKeyLastUsed)) {
            return false;
        }
        AccessKeyLastUsed other = (AccessKeyLastUsed)obj;
        if (other.lastUsedDate() == null ^ this.lastUsedDate() == null) {
            return false;
        }
        if (other.lastUsedDate() != null && !other.lastUsedDate().equals(this.lastUsedDate())) {
            return false;
        }
        if (other.serviceName() == null ^ this.serviceName() == null) {
            return false;
        }
        if (other.serviceName() != null && !other.serviceName().equals(this.serviceName())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        return other.region() == null || other.region().equals(this.region());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lastUsedDate() != null) {
            sb.append("LastUsedDate: ").append(this.lastUsedDate()).append(",");
        }
        if (this.serviceName() != null) {
            sb.append("ServiceName: ").append(this.serviceName()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastUsedDate": {
                return Optional.of(clazz.cast(this.lastUsedDate()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastUsedDate;
        private String serviceName;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKeyLastUsed model) {
            this.lastUsedDate(model.lastUsedDate);
            this.serviceName(model.serviceName);
            this.region(model.region);
        }

        public final Instant getLastUsedDate() {
            return this.lastUsedDate;
        }

        @Override
        public final Builder lastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
            return this;
        }

        public final void setLastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public AccessKeyLastUsed build() {
            return new AccessKeyLastUsed(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessKeyLastUsed> {
        public Builder lastUsedDate(Instant var1);

        public Builder serviceName(String var1);

        public Builder region(String var1);
    }
}

