/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;
import software.amazon.awssdk.services.iam.transform.UserUnmarshaller;

public class VirtualMFADeviceUnmarshaller
implements Unmarshaller<VirtualMFADevice, StaxUnmarshallerContext> {
    private static final VirtualMFADeviceUnmarshaller INSTANCE = new VirtualMFADeviceUnmarshaller();

    public VirtualMFADevice unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        VirtualMFADevice.Builder virtualMFADevice = VirtualMFADevice.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SerialNumber", targetDepth)) {
                    virtualMFADevice.serialNumber(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Base32StringSeed", targetDepth)) {
                    virtualMFADevice.base32StringSeed(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("QRCodePNG", targetDepth)) {
                    virtualMFADevice.qrCodePNG(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("User", targetDepth)) {
                    virtualMFADevice.user(UserUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EnableDate", targetDepth)) continue;
                virtualMFADevice.enableDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (VirtualMFADevice)virtualMFADevice.build();
    }

    public static VirtualMFADeviceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

