/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model.UserDetail;
import software.amazon.awssdk.services.iam.transform.AttachedPolicyUnmarshaller;
import software.amazon.awssdk.services.iam.transform.PolicyDetailUnmarshaller;

public class UserDetailUnmarshaller
implements Unmarshaller<UserDetail, StaxUnmarshallerContext> {
    private static final UserDetailUnmarshaller INSTANCE = new UserDetailUnmarshaller();

    public UserDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        UserDetail.Builder userDetail;
        block14: {
            userDetail = UserDetail.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<PolicyDetail> userPolicyList = null;
            ArrayList<String> groupList = null;
            ArrayList<AttachedPolicy> attachedManagedPolicies = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    userDetail.userPolicyList(userPolicyList);
                    userDetail.groupList(groupList);
                    userDetail.attachedManagedPolicies(attachedManagedPolicies);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Path", targetDepth)) {
                        userDetail.path(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UserName", targetDepth)) {
                        userDetail.userName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UserId", targetDepth)) {
                        userDetail.userId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Arn", targetDepth)) {
                        userDetail.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreateDate", targetDepth)) {
                        userDetail.createDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UserPolicyList", targetDepth)) {
                        userPolicyList = new ArrayList<PolicyDetail>();
                        continue;
                    }
                    if (context.testExpression("UserPolicyList/member", targetDepth)) {
                        userPolicyList.add(PolicyDetailUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("GroupList", targetDepth)) {
                        groupList = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("GroupList/member", targetDepth)) {
                        groupList.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AttachedManagedPolicies", targetDepth)) {
                        attachedManagedPolicies = new ArrayList<AttachedPolicy>();
                        continue;
                    }
                    if (!context.testExpression("AttachedManagedPolicies/member", targetDepth)) continue;
                    attachedManagedPolicies.add(AttachedPolicyUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            userDetail.userPolicyList(userPolicyList);
            userDetail.groupList(groupList);
            userDetail.attachedManagedPolicies(attachedManagedPolicies);
        }
        return (UserDetail)userDetail.build();
    }

    public static UserDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}

