/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResult;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.transform.StatementUnmarshaller;

public class ResourceSpecificResultUnmarshaller
implements Unmarshaller<ResourceSpecificResult, StaxUnmarshallerContext> {
    private static final ResourceSpecificResultUnmarshaller INSTANCE = new ResourceSpecificResultUnmarshaller();

    public ResourceSpecificResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceSpecificResult.Builder resourceSpecificResult;
        block11: {
            resourceSpecificResult = ResourceSpecificResult.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Statement> matchedStatements = null;
            ArrayList<String> missingContextValues = null;
            HashMap<String, String> evalDecisionDetails = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    resourceSpecificResult.matchedStatements(matchedStatements);
                    resourceSpecificResult.missingContextValues(missingContextValues);
                    resourceSpecificResult.evalDecisionDetails(evalDecisionDetails);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("EvalResourceName", targetDepth)) {
                        resourceSpecificResult.evalResourceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EvalResourceDecision", targetDepth)) {
                        resourceSpecificResult.evalResourceDecision(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MatchedStatements", targetDepth)) {
                        matchedStatements = new ArrayList<Statement>();
                        continue;
                    }
                    if (context.testExpression("MatchedStatements/member", targetDepth)) {
                        matchedStatements.add(StatementUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MissingContextValues", targetDepth)) {
                        missingContextValues = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("MissingContextValues/member", targetDepth)) {
                        missingContextValues.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EvalDecisionDetails/entry", targetDepth)) continue;
                    if (evalDecisionDetails == null) {
                        evalDecisionDetails = new HashMap<String, String>();
                    }
                    Map.Entry<String, String> entry = EvalDecisionDetailsMapEntryUnmarshaller.getInstance().unmarshall(context);
                    evalDecisionDetails.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            resourceSpecificResult.matchedStatements(matchedStatements);
            resourceSpecificResult.missingContextValues(missingContextValues);
            resourceSpecificResult.evalDecisionDetails(evalDecisionDetails);
        }
        return (ResourceSpecificResult)resourceSpecificResult.build();
    }

    public static ResourceSpecificResultUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class EvalDecisionDetailsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static final EvalDecisionDetailsMapEntryUnmarshaller INSTANCE = new EvalDecisionDetailsMapEntryUnmarshaller();

        private EvalDecisionDetailsMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static EvalDecisionDetailsMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

