/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetUserPolicyRequestMarshaller
implements Marshaller<Request<GetUserPolicyRequest>, GetUserPolicyRequest> {
    public Request<GetUserPolicyRequest> marshall(GetUserPolicyRequest getUserPolicyRequest) {
        if (getUserPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getUserPolicyRequest, "IAMClient");
        request.addParameter("Action", "GetUserPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getUserPolicyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)getUserPolicyRequest.userName()));
        }
        if (getUserPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)getUserPolicyRequest.policyName()));
        }
        return request;
    }
}

