/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateRoleRequestMarshaller
implements Marshaller<Request<CreateRoleRequest>, CreateRoleRequest> {
    public Request<CreateRoleRequest> marshall(CreateRoleRequest createRoleRequest) {
        if (createRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRoleRequest, "IAMClient");
        request.addParameter("Action", "CreateRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRoleRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createRoleRequest.path()));
        }
        if (createRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)createRoleRequest.roleName()));
        }
        if (createRoleRequest.assumeRolePolicyDocument() != null) {
            request.addParameter("AssumeRolePolicyDocument", StringUtils.fromString((String)createRoleRequest.assumeRolePolicyDocument()));
        }
        if (createRoleRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createRoleRequest.description()));
        }
        return request;
    }
}

