/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SSHPublicKey
implements ToCopyableBuilder<Builder, SSHPublicKey> {
    private final String userName;
    private final String sshPublicKeyId;
    private final String fingerprint;
    private final String sshPublicKeyBody;
    private final String status;
    private final Instant uploadDate;

    private SSHPublicKey(BuilderImpl builder) {
        this.userName = builder.userName;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.fingerprint = builder.fingerprint;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
        this.status = builder.status;
        this.uploadDate = builder.uploadDate;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public String fingerprint() {
        return this.fingerprint;
    }

    public String sshPublicKeyBody() {
        return this.sshPublicKeyBody;
    }

    public String status() {
        return this.status;
    }

    public Instant uploadDate() {
        return this.uploadDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.sshPublicKeyId() == null ? 0 : this.sshPublicKeyId().hashCode());
        hashCode = 31 * hashCode + (this.fingerprint() == null ? 0 : this.fingerprint().hashCode());
        hashCode = 31 * hashCode + (this.sshPublicKeyBody() == null ? 0 : this.sshPublicKeyBody().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.uploadDate() == null ? 0 : this.uploadDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSHPublicKey)) {
            return false;
        }
        SSHPublicKey other = (SSHPublicKey)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.sshPublicKeyId() == null ^ this.sshPublicKeyId() == null) {
            return false;
        }
        if (other.sshPublicKeyId() != null && !other.sshPublicKeyId().equals(this.sshPublicKeyId())) {
            return false;
        }
        if (other.fingerprint() == null ^ this.fingerprint() == null) {
            return false;
        }
        if (other.fingerprint() != null && !other.fingerprint().equals(this.fingerprint())) {
            return false;
        }
        if (other.sshPublicKeyBody() == null ^ this.sshPublicKeyBody() == null) {
            return false;
        }
        if (other.sshPublicKeyBody() != null && !other.sshPublicKeyBody().equals(this.sshPublicKeyBody())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.uploadDate() == null ^ this.uploadDate() == null) {
            return false;
        }
        return other.uploadDate() == null || other.uploadDate().equals(this.uploadDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.sshPublicKeyId() != null) {
            sb.append("SSHPublicKeyId: ").append(this.sshPublicKeyId()).append(",");
        }
        if (this.fingerprint() != null) {
            sb.append("Fingerprint: ").append(this.fingerprint()).append(",");
        }
        if (this.sshPublicKeyBody() != null) {
            sb.append("SSHPublicKeyBody: ").append(this.sshPublicKeyBody()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.uploadDate() != null) {
            sb.append("UploadDate: ").append(this.uploadDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyId;
        private String fingerprint;
        private String sshPublicKeyBody;
        private String status;
        private Instant uploadDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SSHPublicKey model) {
            this.setUserName(model.userName);
            this.setSSHPublicKeyId(model.sshPublicKeyId);
            this.setFingerprint(model.fingerprint);
            this.setSSHPublicKeyBody(model.sshPublicKeyBody);
            this.setStatus(model.status);
            this.setUploadDate(model.uploadDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSSHPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getFingerprint() {
            return this.fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        public final String getSSHPublicKeyBody() {
            return this.sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final void setSSHPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public SSHPublicKey build() {
            return new SSHPublicKey(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SSHPublicKey> {
        public Builder userName(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder fingerprint(String var1);

        public Builder sshPublicKeyBody(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder uploadDate(Instant var1);
    }
}

