/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._instanceProfileListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RoleDetail
implements ToCopyableBuilder<Builder, RoleDetail> {
    private final String path;
    private final String roleName;
    private final String roleId;
    private final String arn;
    private final Instant createDate;
    private final String assumeRolePolicyDocument;
    private final List<InstanceProfile> instanceProfileList;
    private final List<PolicyDetail> rolePolicyList;
    private final List<AttachedPolicy> attachedManagedPolicies;

    private RoleDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.instanceProfileList = builder.instanceProfileList;
        this.rolePolicyList = builder.rolePolicyList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
    }

    public String path() {
        return this.path;
    }

    public String roleName() {
        return this.roleName;
    }

    public String roleId() {
        return this.roleId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public List<InstanceProfile> instanceProfileList() {
        return this.instanceProfileList;
    }

    public List<PolicyDetail> rolePolicyList() {
        return this.rolePolicyList;
    }

    public List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.roleName() == null ? 0 : this.roleName().hashCode());
        hashCode = 31 * hashCode + (this.roleId() == null ? 0 : this.roleId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.assumeRolePolicyDocument() == null ? 0 : this.assumeRolePolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.instanceProfileList() == null ? 0 : this.instanceProfileList().hashCode());
        hashCode = 31 * hashCode + (this.rolePolicyList() == null ? 0 : this.rolePolicyList().hashCode());
        hashCode = 31 * hashCode + (this.attachedManagedPolicies() == null ? 0 : this.attachedManagedPolicies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleDetail)) {
            return false;
        }
        RoleDetail other = (RoleDetail)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.roleName() == null ^ this.roleName() == null) {
            return false;
        }
        if (other.roleName() != null && !other.roleName().equals(this.roleName())) {
            return false;
        }
        if (other.roleId() == null ^ this.roleId() == null) {
            return false;
        }
        if (other.roleId() != null && !other.roleId().equals(this.roleId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.assumeRolePolicyDocument() == null ^ this.assumeRolePolicyDocument() == null) {
            return false;
        }
        if (other.assumeRolePolicyDocument() != null && !other.assumeRolePolicyDocument().equals(this.assumeRolePolicyDocument())) {
            return false;
        }
        if (other.instanceProfileList() == null ^ this.instanceProfileList() == null) {
            return false;
        }
        if (other.instanceProfileList() != null && !other.instanceProfileList().equals(this.instanceProfileList())) {
            return false;
        }
        if (other.rolePolicyList() == null ^ this.rolePolicyList() == null) {
            return false;
        }
        if (other.rolePolicyList() != null && !other.rolePolicyList().equals(this.rolePolicyList())) {
            return false;
        }
        if (other.attachedManagedPolicies() == null ^ this.attachedManagedPolicies() == null) {
            return false;
        }
        return other.attachedManagedPolicies() == null || other.attachedManagedPolicies().equals(this.attachedManagedPolicies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        if (this.roleId() != null) {
            sb.append("RoleId: ").append(this.roleId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.assumeRolePolicyDocument() != null) {
            sb.append("AssumeRolePolicyDocument: ").append(this.assumeRolePolicyDocument()).append(",");
        }
        if (this.instanceProfileList() != null) {
            sb.append("InstanceProfileList: ").append(this.instanceProfileList()).append(",");
        }
        if (this.rolePolicyList() != null) {
            sb.append("RolePolicyList: ").append(this.rolePolicyList()).append(",");
        }
        if (this.attachedManagedPolicies() != null) {
            sb.append("AttachedManagedPolicies: ").append(this.attachedManagedPolicies()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String roleName;
        private String roleId;
        private String arn;
        private Instant createDate;
        private String assumeRolePolicyDocument;
        private List<InstanceProfile> instanceProfileList;
        private List<PolicyDetail> rolePolicyList;
        private List<AttachedPolicy> attachedManagedPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleDetail model) {
            this.setPath(model.path);
            this.setRoleName(model.roleName);
            this.setRoleId(model.roleId);
            this.setArn(model.arn);
            this.setCreateDate(model.createDate);
            this.setAssumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.setInstanceProfileList(model.instanceProfileList);
            this.setRolePolicyList(model.rolePolicyList);
            this.setAttachedManagedPolicies(model.attachedManagedPolicies);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final Collection<InstanceProfile> getInstanceProfileList() {
            return this.instanceProfileList;
        }

        @Override
        public final Builder instanceProfileList(Collection<InstanceProfile> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copy(instanceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(InstanceProfile ... instanceProfileList) {
            this.instanceProfileList(Arrays.asList(instanceProfileList));
            return this;
        }

        public final void setInstanceProfileList(Collection<InstanceProfile> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copy(instanceProfileList);
        }

        public final Collection<PolicyDetail> getRolePolicyList() {
            return this.rolePolicyList;
        }

        @Override
        public final Builder rolePolicyList(Collection<PolicyDetail> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copy(rolePolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(PolicyDetail ... rolePolicyList) {
            this.rolePolicyList(Arrays.asList(rolePolicyList));
            return this;
        }

        public final void setRolePolicyList(Collection<PolicyDetail> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copy(rolePolicyList);
        }

        public final Collection<AttachedPolicy> getAttachedManagedPolicies() {
            return this.attachedManagedPolicies;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
        }

        public RoleDetail build() {
            return new RoleDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RoleDetail> {
        public Builder path(String var1);

        public Builder roleName(String var1);

        public Builder roleId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder assumeRolePolicyDocument(String var1);

        public Builder instanceProfileList(Collection<InstanceProfile> var1);

        public Builder instanceProfileList(InstanceProfile ... var1);

        public Builder rolePolicyList(Collection<PolicyDetail> var1);

        public Builder rolePolicyList(PolicyDetail ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);
    }
}

