/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyListTypeCopier;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSSHPublicKeysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSSHPublicKeysResponse> {
    private final List<SSHPublicKeyMetadata> sshPublicKeys;
    private final Boolean isTruncated;
    private final String marker;

    private ListSSHPublicKeysResponse(BuilderImpl builder) {
        this.sshPublicKeys = builder.sshPublicKeys;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<SSHPublicKeyMetadata> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sshPublicKeys() == null ? 0 : this.sshPublicKeys().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSSHPublicKeysResponse)) {
            return false;
        }
        ListSSHPublicKeysResponse other = (ListSSHPublicKeysResponse)((Object)obj);
        if (other.sshPublicKeys() == null ^ this.sshPublicKeys() == null) {
            return false;
        }
        if (other.sshPublicKeys() != null && !other.sshPublicKeys().equals(this.sshPublicKeys())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sshPublicKeys() != null) {
            sb.append("SSHPublicKeys: ").append(this.sshPublicKeys()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<SSHPublicKeyMetadata> sshPublicKeys;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSSHPublicKeysResponse model) {
            this.setSSHPublicKeys(model.sshPublicKeys);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<SSHPublicKeyMetadata> getSSHPublicKeys() {
            return this.sshPublicKeys;
        }

        @Override
        public final Builder sshPublicKeys(Collection<SSHPublicKeyMetadata> sshPublicKeys) {
            this.sshPublicKeys = SSHPublicKeyListTypeCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(SSHPublicKeyMetadata ... sshPublicKeys) {
            this.sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        public final void setSSHPublicKeys(Collection<SSHPublicKeyMetadata> sshPublicKeys) {
            this.sshPublicKeys = SSHPublicKeyListTypeCopier.copy(sshPublicKeys);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListSSHPublicKeysResponse build() {
            return new ListSSHPublicKeysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSSHPublicKeysResponse> {
        public Builder sshPublicKeys(Collection<SSHPublicKeyMetadata> var1);

        public Builder sshPublicKeys(SSHPublicKeyMetadata ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

