/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.model._roleListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceProfile
implements ToCopyableBuilder<Builder, InstanceProfile> {
    private final String path;
    private final String instanceProfileName;
    private final String instanceProfileId;
    private final String arn;
    private final Instant createDate;
    private final List<Role> roles;

    private InstanceProfile(BuilderImpl builder) {
        this.path = builder.path;
        this.instanceProfileName = builder.instanceProfileName;
        this.instanceProfileId = builder.instanceProfileId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.roles = builder.roles;
    }

    public String path() {
        return this.path;
    }

    public String instanceProfileName() {
        return this.instanceProfileName;
    }

    public String instanceProfileId() {
        return this.instanceProfileId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.instanceProfileName() == null ? 0 : this.instanceProfileName().hashCode());
        hashCode = 31 * hashCode + (this.instanceProfileId() == null ? 0 : this.instanceProfileId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.roles() == null ? 0 : this.roles().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProfile)) {
            return false;
        }
        InstanceProfile other = (InstanceProfile)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.instanceProfileName() == null ^ this.instanceProfileName() == null) {
            return false;
        }
        if (other.instanceProfileName() != null && !other.instanceProfileName().equals(this.instanceProfileName())) {
            return false;
        }
        if (other.instanceProfileId() == null ^ this.instanceProfileId() == null) {
            return false;
        }
        if (other.instanceProfileId() != null && !other.instanceProfileId().equals(this.instanceProfileId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.roles() == null ^ this.roles() == null) {
            return false;
        }
        return other.roles() == null || other.roles().equals(this.roles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.instanceProfileName() != null) {
            sb.append("InstanceProfileName: ").append(this.instanceProfileName()).append(",");
        }
        if (this.instanceProfileId() != null) {
            sb.append("InstanceProfileId: ").append(this.instanceProfileId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.roles() != null) {
            sb.append("Roles: ").append(this.roles()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String instanceProfileName;
        private String instanceProfileId;
        private String arn;
        private Instant createDate;
        private List<Role> roles;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProfile model) {
            this.setPath(model.path);
            this.setInstanceProfileName(model.instanceProfileName);
            this.setInstanceProfileId(model.instanceProfileId);
            this.setArn(model.arn);
            this.setCreateDate(model.createDate);
            this.setRoles(model.roles);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        public final String getInstanceProfileId() {
            return this.instanceProfileId;
        }

        @Override
        public final Builder instanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
            return this;
        }

        public final void setInstanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<Role> getRoles() {
            return this.roles;
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = _roleListTypeCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        public final void setRoles(Collection<Role> roles) {
            this.roles = _roleListTypeCopier.copy(roles);
        }

        public InstanceProfile build() {
            return new InstanceProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceProfile> {
        public Builder path(String var1);

        public Builder instanceProfileName(String var1);

        public Builder instanceProfileId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);
    }
}

