/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.services.iam.model._userListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetGroupResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetGroupResponse> {
    private final Group group;
    private final List<User> users;
    private final Boolean isTruncated;
    private final String marker;

    private GetGroupResponse(BuilderImpl builder) {
        this.group = builder.group;
        this.users = builder.users;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public Group group() {
        return this.group;
    }

    public List<User> users() {
        return this.users;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.group() == null ? 0 : this.group().hashCode());
        hashCode = 31 * hashCode + (this.users() == null ? 0 : this.users().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupResponse)) {
            return false;
        }
        GetGroupResponse other = (GetGroupResponse)((Object)obj);
        if (other.group() == null ^ this.group() == null) {
            return false;
        }
        if (other.group() != null && !other.group().equals(this.group())) {
            return false;
        }
        if (other.users() == null ^ this.users() == null) {
            return false;
        }
        if (other.users() != null && !other.users().equals(this.users())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.group() != null) {
            sb.append("Group: ").append(this.group()).append(",");
        }
        if (this.users() != null) {
            sb.append("Users: ").append(this.users()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Group group;
        private List<User> users;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupResponse model) {
            this.setGroup(model.group);
            this.setUsers(model.users);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Group getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(Group group) {
            this.group = group;
            return this;
        }

        public final void setGroup(Group group) {
            this.group = group;
        }

        public final Collection<User> getUsers() {
            return this.users;
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = _userListTypeCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<User> users) {
            this.users = _userListTypeCopier.copy(users);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public GetGroupResponse build() {
            return new GetGroupResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetGroupResponse> {
        public Builder group(Group var1);

        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

