/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model.EntityType;
import software.amazon.awssdk.services.iam.model._entityListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAccountAuthorizationDetailsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetAccountAuthorizationDetailsRequest> {
    private final List<String> filter;
    private final Integer maxItems;
    private final String marker;

    private GetAccountAuthorizationDetailsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    public List<String> filter() {
        return this.filter;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAuthorizationDetailsRequest)) {
            return false;
        }
        GetAccountAuthorizationDetailsRequest other = (GetAccountAuthorizationDetailsRequest)((Object)obj);
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> filter;
        private Integer maxItems;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAuthorizationDetailsRequest model) {
            this.setFilter(model.filter);
            this.setMaxItems(model.maxItems);
            this.setMarker(model.marker);
        }

        public final Collection<String> getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(String ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(EntityType ... filter) {
            this.filter(Arrays.asList(filter).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setFilter(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public GetAccountAuthorizationDetailsRequest build() {
            return new GetAccountAuthorizationDetailsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAccountAuthorizationDetailsRequest> {
        public Builder filter(Collection<String> var1);

        public Builder filter(String ... var1);

        public Builder filter(EntityType ... var1);

        public Builder maxItems(Integer var1);

        public Builder marker(String var1);
    }
}

