/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UpdateOpenIDConnectProviderThumbprintRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateOpenIDConnectProviderThumbprintRequestMarshaller
implements Marshaller<Request<UpdateOpenIDConnectProviderThumbprintRequest>, UpdateOpenIDConnectProviderThumbprintRequest> {
    public Request<UpdateOpenIDConnectProviderThumbprintRequest> marshall(UpdateOpenIDConnectProviderThumbprintRequest updateOpenIDConnectProviderThumbprintRequest) {
        List<String> thumbprintListList;
        if (updateOpenIDConnectProviderThumbprintRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateOpenIDConnectProviderThumbprintRequest, "IAMClient");
        request.addParameter("Action", "UpdateOpenIDConnectProviderThumbprint");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateOpenIDConnectProviderThumbprintRequest.openIDConnectProviderArn() != null) {
            request.addParameter("OpenIDConnectProviderArn", StringUtils.fromString((String)updateOpenIDConnectProviderThumbprintRequest.openIDConnectProviderArn()));
        }
        if ((thumbprintListList = updateOpenIDConnectProviderThumbprintRequest.thumbprintList()) != null) {
            if (!thumbprintListList.isEmpty()) {
                int thumbprintListListIndex = 1;
                for (String thumbprintListListValue : thumbprintListList) {
                    if (thumbprintListListValue != null) {
                        request.addParameter("ThumbprintList.member." + thumbprintListListIndex, StringUtils.fromString((String)thumbprintListListValue));
                    }
                    ++thumbprintListListIndex;
                }
            } else {
                request.addParameter("ThumbprintList", "");
            }
        }
        return request;
    }
}

