/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.MFADevice;

public class MFADeviceUnmarshaller
implements Unmarshaller<MFADevice, StaxUnmarshallerContext> {
    private static MFADeviceUnmarshaller INSTANCE;

    public MFADevice unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MFADevice.Builder mfaDevice = MFADevice.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("UserName", targetDepth)) {
                    mfaDevice.userName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SerialNumber", targetDepth)) {
                    mfaDevice.serialNumber(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EnableDate", targetDepth)) continue;
                mfaDevice.enableDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MFADevice)mfaDevice.build();
    }

    public static MFADeviceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MFADeviceUnmarshaller();
        }
        return INSTANCE;
    }
}

