/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteAccessKeyRequestMarshaller
implements Marshaller<Request<DeleteAccessKeyRequest>, DeleteAccessKeyRequest> {
    public Request<DeleteAccessKeyRequest> marshall(DeleteAccessKeyRequest deleteAccessKeyRequest) {
        if (deleteAccessKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAccessKeyRequest, "IAMClient");
        request.addParameter("Action", "DeleteAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAccessKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)deleteAccessKeyRequest.userName()));
        }
        if (deleteAccessKeyRequest.accessKeyId() != null) {
            request.addParameter("AccessKeyId", StringUtils.fromString((String)deleteAccessKeyRequest.accessKeyId()));
        }
        return request;
    }
}

