/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._groupNameListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UserDetail
implements ToCopyableBuilder<Builder, UserDetail> {
    private final String path;
    private final String userName;
    private final String userId;
    private final String arn;
    private final Instant createDate;
    private final List<PolicyDetail> userPolicyList;
    private final List<String> groupList;
    private final List<AttachedPolicy> attachedManagedPolicies;

    private UserDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.userPolicyList = builder.userPolicyList;
        this.groupList = builder.groupList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
    }

    public String path() {
        return this.path;
    }

    public String userName() {
        return this.userName;
    }

    public String userId() {
        return this.userId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public List<PolicyDetail> userPolicyList() {
        return this.userPolicyList;
    }

    public List<String> groupList() {
        return this.groupList;
    }

    public List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.userId() == null ? 0 : this.userId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.userPolicyList() == null ? 0 : this.userPolicyList().hashCode());
        hashCode = 31 * hashCode + (this.groupList() == null ? 0 : this.groupList().hashCode());
        hashCode = 31 * hashCode + (this.attachedManagedPolicies() == null ? 0 : this.attachedManagedPolicies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDetail)) {
            return false;
        }
        UserDetail other = (UserDetail)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        if (other.userId() != null && !other.userId().equals(this.userId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.userPolicyList() == null ^ this.userPolicyList() == null) {
            return false;
        }
        if (other.userPolicyList() != null && !other.userPolicyList().equals(this.userPolicyList())) {
            return false;
        }
        if (other.groupList() == null ^ this.groupList() == null) {
            return false;
        }
        if (other.groupList() != null && !other.groupList().equals(this.groupList())) {
            return false;
        }
        if (other.attachedManagedPolicies() == null ^ this.attachedManagedPolicies() == null) {
            return false;
        }
        return other.attachedManagedPolicies() == null || other.attachedManagedPolicies().equals(this.attachedManagedPolicies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.userPolicyList() != null) {
            sb.append("UserPolicyList: ").append(this.userPolicyList()).append(",");
        }
        if (this.groupList() != null) {
            sb.append("GroupList: ").append(this.groupList()).append(",");
        }
        if (this.attachedManagedPolicies() != null) {
            sb.append("AttachedManagedPolicies: ").append(this.attachedManagedPolicies()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String userName;
        private String userId;
        private String arn;
        private Instant createDate;
        private List<PolicyDetail> userPolicyList;
        private List<String> groupList;
        private List<AttachedPolicy> attachedManagedPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(UserDetail model) {
            this.setPath(model.path);
            this.setUserName(model.userName);
            this.setUserId(model.userId);
            this.setArn(model.arn);
            this.setCreateDate(model.createDate);
            this.setUserPolicyList(model.userPolicyList);
            this.setGroupList(model.groupList);
            this.setAttachedManagedPolicies(model.attachedManagedPolicies);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<PolicyDetail> getUserPolicyList() {
            return this.userPolicyList;
        }

        @Override
        public final Builder userPolicyList(Collection<PolicyDetail> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copy(userPolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPolicyList(PolicyDetail ... userPolicyList) {
            this.userPolicyList(Arrays.asList(userPolicyList));
            return this;
        }

        public final void setUserPolicyList(Collection<PolicyDetail> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copy(userPolicyList);
        }

        @SafeVarargs
        public final void setUserPolicyList(PolicyDetail ... userPolicyList) {
            this.userPolicyList(Arrays.asList(userPolicyList));
        }

        public final Collection<String> getGroupList() {
            return this.groupList;
        }

        @Override
        public final Builder groupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(String ... groupList) {
            this.groupList(Arrays.asList(groupList));
            return this;
        }

        public final void setGroupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
        }

        @SafeVarargs
        public final void setGroupList(String ... groupList) {
            this.groupList(Arrays.asList(groupList));
        }

        public final Collection<AttachedPolicy> getAttachedManagedPolicies() {
            return this.attachedManagedPolicies;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
        }

        @SafeVarargs
        public final void setAttachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
        }

        public UserDetail build() {
            return new UserDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserDetail> {
        public Builder path(String var1);

        public Builder userName(String var1);

        public Builder userId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder userPolicyList(Collection<PolicyDetail> var1);

        public Builder userPolicyList(PolicyDetail ... var1);

        public Builder groupList(Collection<String> var1);

        public Builder groupList(String ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);
    }
}

