/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadSSHPublicKeyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UploadSSHPublicKeyRequest> {
    private final String userName;
    private final String sshPublicKeyBody;

    private UploadSSHPublicKeyRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyBody() {
        return this.sshPublicKeyBody;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.sshPublicKeyBody() == null ? 0 : this.sshPublicKeyBody().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSSHPublicKeyRequest)) {
            return false;
        }
        UploadSSHPublicKeyRequest other = (UploadSSHPublicKeyRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.sshPublicKeyBody() == null ^ this.sshPublicKeyBody() == null) {
            return false;
        }
        return other.sshPublicKeyBody() == null || other.sshPublicKeyBody().equals(this.sshPublicKeyBody());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.sshPublicKeyBody() != null) {
            sb.append("SSHPublicKeyBody: ").append(this.sshPublicKeyBody()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSSHPublicKeyRequest model) {
            this.setUserName(model.userName);
            this.setSSHPublicKeyBody(model.sshPublicKeyBody);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyBody() {
            return this.sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final void setSSHPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        public UploadSSHPublicKeyRequest build() {
            return new UploadSSHPublicKeyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadSSHPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyBody(String var1);
    }
}

