/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.MFADevice;
import software.amazon.awssdk.services.iam.model._mfaDeviceListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMFADevicesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListMFADevicesResponse> {
    private final List<MFADevice> mfaDevices;
    private final Boolean isTruncated;
    private final String marker;

    private ListMFADevicesResponse(BuilderImpl builder) {
        this.mfaDevices = builder.mfaDevices;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<MFADevice> mfaDevices() {
        return this.mfaDevices;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mfaDevices() == null ? 0 : this.mfaDevices().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMFADevicesResponse)) {
            return false;
        }
        ListMFADevicesResponse other = (ListMFADevicesResponse)((Object)obj);
        if (other.mfaDevices() == null ^ this.mfaDevices() == null) {
            return false;
        }
        if (other.mfaDevices() != null && !other.mfaDevices().equals(this.mfaDevices())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mfaDevices() != null) {
            sb.append("MFADevices: ").append(this.mfaDevices()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MFADevice> mfaDevices;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMFADevicesResponse model) {
            this.setMFADevices(model.mfaDevices);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<MFADevice> getMFADevices() {
            return this.mfaDevices;
        }

        @Override
        public final Builder mfaDevices(Collection<MFADevice> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copy(mfaDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(MFADevice ... mfaDevices) {
            this.mfaDevices(Arrays.asList(mfaDevices));
            return this;
        }

        public final void setMFADevices(Collection<MFADevice> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copy(mfaDevices);
        }

        @SafeVarargs
        public final void setMFADevices(MFADevice ... mfaDevices) {
            this.mfaDevices(Arrays.asList(mfaDevices));
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListMFADevicesResponse build() {
            return new ListMFADevicesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListMFADevicesResponse> {
        public Builder mfaDevices(Collection<MFADevice> var1);

        public Builder mfaDevices(MFADevice ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

