/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.iam.model.ContextKeyTypeEnum;
import software.amazon.awssdk.services.iam.model.ContextKeyValueListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContextEntry
implements ToCopyableBuilder<Builder, ContextEntry> {
    private final String contextKeyName;
    private final List<String> contextKeyValues;
    private final String contextKeyType;

    private ContextEntry(BuilderImpl builder) {
        this.contextKeyName = builder.contextKeyName;
        this.contextKeyValues = builder.contextKeyValues;
        this.contextKeyType = builder.contextKeyType;
    }

    public String contextKeyName() {
        return this.contextKeyName;
    }

    public List<String> contextKeyValues() {
        return this.contextKeyValues;
    }

    public String contextKeyType() {
        return this.contextKeyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.contextKeyName() == null ? 0 : this.contextKeyName().hashCode());
        hashCode = 31 * hashCode + (this.contextKeyValues() == null ? 0 : this.contextKeyValues().hashCode());
        hashCode = 31 * hashCode + (this.contextKeyType() == null ? 0 : this.contextKeyType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextEntry)) {
            return false;
        }
        ContextEntry other = (ContextEntry)obj;
        if (other.contextKeyName() == null ^ this.contextKeyName() == null) {
            return false;
        }
        if (other.contextKeyName() != null && !other.contextKeyName().equals(this.contextKeyName())) {
            return false;
        }
        if (other.contextKeyValues() == null ^ this.contextKeyValues() == null) {
            return false;
        }
        if (other.contextKeyValues() != null && !other.contextKeyValues().equals(this.contextKeyValues())) {
            return false;
        }
        if (other.contextKeyType() == null ^ this.contextKeyType() == null) {
            return false;
        }
        return other.contextKeyType() == null || other.contextKeyType().equals(this.contextKeyType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.contextKeyName() != null) {
            sb.append("ContextKeyName: ").append(this.contextKeyName()).append(",");
        }
        if (this.contextKeyValues() != null) {
            sb.append("ContextKeyValues: ").append(this.contextKeyValues()).append(",");
        }
        if (this.contextKeyType() != null) {
            sb.append("ContextKeyType: ").append(this.contextKeyType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String contextKeyName;
        private List<String> contextKeyValues;
        private String contextKeyType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextEntry model) {
            this.setContextKeyName(model.contextKeyName);
            this.setContextKeyValues(model.contextKeyValues);
            this.setContextKeyType(model.contextKeyType);
        }

        public final String getContextKeyName() {
            return this.contextKeyName;
        }

        @Override
        public final Builder contextKeyName(String contextKeyName) {
            this.contextKeyName = contextKeyName;
            return this;
        }

        public final void setContextKeyName(String contextKeyName) {
            this.contextKeyName = contextKeyName;
        }

        public final Collection<String> getContextKeyValues() {
            return this.contextKeyValues;
        }

        @Override
        public final Builder contextKeyValues(Collection<String> contextKeyValues) {
            this.contextKeyValues = ContextKeyValueListTypeCopier.copy(contextKeyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeyValues(String ... contextKeyValues) {
            this.contextKeyValues(Arrays.asList(contextKeyValues));
            return this;
        }

        public final void setContextKeyValues(Collection<String> contextKeyValues) {
            this.contextKeyValues = ContextKeyValueListTypeCopier.copy(contextKeyValues);
        }

        @SafeVarargs
        public final void setContextKeyValues(String ... contextKeyValues) {
            this.contextKeyValues(Arrays.asList(contextKeyValues));
        }

        public final String getContextKeyType() {
            return this.contextKeyType;
        }

        @Override
        public final Builder contextKeyType(String contextKeyType) {
            this.contextKeyType = contextKeyType;
            return this;
        }

        @Override
        public final Builder contextKeyType(ContextKeyTypeEnum contextKeyType) {
            this.contextKeyType(contextKeyType.toString());
            return this;
        }

        public final void setContextKeyType(String contextKeyType) {
            this.contextKeyType = contextKeyType;
        }

        public final void setContextKeyType(ContextKeyTypeEnum contextKeyType) {
            this.contextKeyType(contextKeyType.toString());
        }

        public ContextEntry build() {
            return new ContextEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContextEntry> {
        public Builder contextKeyName(String var1);

        public Builder contextKeyValues(Collection<String> var1);

        public Builder contextKeyValues(String ... var1);

        public Builder contextKeyType(String var1);

        public Builder contextKeyType(ContextKeyTypeEnum var1);
    }
}

