/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccessKey
implements ToCopyableBuilder<Builder, AccessKey> {
    private final String userName;
    private final String accessKeyId;
    private final String status;
    private final String secretAccessKey;
    private final Instant createDate;

    private AccessKey(BuilderImpl builder) {
        this.userName = builder.userName;
        this.accessKeyId = builder.accessKeyId;
        this.status = builder.status;
        this.secretAccessKey = builder.secretAccessKey;
        this.createDate = builder.createDate;
    }

    public String userName() {
        return this.userName;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String status() {
        return this.status;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.accessKeyId() == null ? 0 : this.accessKeyId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.secretAccessKey() == null ? 0 : this.secretAccessKey().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKey)) {
            return false;
        }
        AccessKey other = (AccessKey)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.accessKeyId() == null ^ this.accessKeyId() == null) {
            return false;
        }
        if (other.accessKeyId() != null && !other.accessKeyId().equals(this.accessKeyId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.secretAccessKey() == null ^ this.secretAccessKey() == null) {
            return false;
        }
        if (other.secretAccessKey() != null && !other.secretAccessKey().equals(this.secretAccessKey())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        return other.createDate() == null || other.createDate().equals(this.createDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(this.accessKeyId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.secretAccessKey() != null) {
            sb.append("SecretAccessKey: ").append(this.secretAccessKey()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String userName;
        private String accessKeyId;
        private String status;
        private String secretAccessKey;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKey model) {
            this.setUserName(model.userName);
            this.setAccessKeyId(model.accessKeyId);
            this.setStatus(model.status);
            this.setSecretAccessKey(model.secretAccessKey);
            this.setCreateDate(model.createDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(StatusType status) {
            this.status(status.toString());
        }

        public final String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public AccessKey build() {
            return new AccessKey(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessKey> {
        public Builder userName(String var1);

        public Builder accessKeyId(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder secretAccessKey(String var1);

        public Builder createDate(Instant var1);
    }
}

