/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Role
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Role> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Role.getter(Role::path)).setter(Role.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Role.getter(Role::roleName)).setter(Role.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> ROLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Role.getter(Role::roleId)).setter(Role.setter(Builder::roleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Role.getter(Role::arn)).setter(Role.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Role.getter(Role::createDate)).setter(Role.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Role.getter(Role::assumeRolePolicyDocument)).setter(Role.setter(Builder::assumeRolePolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Role.getter(Role::description)).setter(Role.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Role.getter(Role::maxSessionDuration)).setter(Role.setter(Builder::maxSessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build()}).build();
    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Role.getter(Role::permissionsBoundary)).setter(Role.setter(Builder::permissionsBoundary)).constructor(AttachedPermissionsBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, ROLE_NAME_FIELD, ROLE_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, ASSUME_ROLE_POLICY_DOCUMENT_FIELD, DESCRIPTION_FIELD, MAX_SESSION_DURATION_FIELD, PERMISSIONS_BOUNDARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String roleName;
    private final String roleId;
    private final String arn;
    private final Instant createDate;
    private final String assumeRolePolicyDocument;
    private final String description;
    private final Integer maxSessionDuration;
    private final AttachedPermissionsBoundary permissionsBoundary;

    private Role(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.description = builder.description;
        this.maxSessionDuration = builder.maxSessionDuration;
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    public String path() {
        return this.path;
    }

    public String roleName() {
        return this.roleName;
    }

    public String roleId() {
        return this.roleId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public String description() {
        return this.description;
    }

    public Integer maxSessionDuration() {
        return this.maxSessionDuration;
    }

    public AttachedPermissionsBoundary permissionsBoundary() {
        return this.permissionsBoundary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.roleId(), other.roleId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.assumeRolePolicyDocument(), other.assumeRolePolicyDocument()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maxSessionDuration(), other.maxSessionDuration()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary());
    }

    public String toString() {
        return ToString.builder((String)"Role").add("Path", (Object)this.path()).add("RoleName", (Object)this.roleName()).add("RoleId", (Object)this.roleId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("AssumeRolePolicyDocument", (Object)this.assumeRolePolicyDocument()).add("Description", (Object)this.description()).add("MaxSessionDuration", (Object)this.maxSessionDuration()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "RoleId": {
                return Optional.ofNullable(clazz.cast(this.roleId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "AssumeRolePolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.assumeRolePolicyDocument()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MaxSessionDuration": {
                return Optional.ofNullable(clazz.cast(this.maxSessionDuration()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Role, T> g) {
        return obj -> g.apply((Role)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String roleName;
        private String roleId;
        private String arn;
        private Instant createDate;
        private String assumeRolePolicyDocument;
        private String description;
        private Integer maxSessionDuration;
        private AttachedPermissionsBoundary permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(Role model) {
            this.path(model.path);
            this.roleName(model.roleName);
            this.roleId(model.roleId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.description(model.description);
            this.maxSessionDuration(model.maxSessionDuration);
            this.permissionsBoundary(model.permissionsBoundary);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getMaxSessionDuration() {
            return this.maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return this.permissionsBoundary != null ? this.permissionsBoundary.toBuilder() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        public Role build() {
            return new Role(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Role> {
        public Builder path(String var1);

        public Builder roleName(String var1);

        public Builder roleId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder assumeRolePolicyDocument(String var1);

        public Builder description(String var1);

        public Builder maxSessionDuration(Integer var1);

        public Builder permissionsBoundary(AttachedPermissionsBoundary var1);

        default public Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return this.permissionsBoundary((AttachedPermissionsBoundary)((AttachedPermissionsBoundary.Builder)AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary)).build());
        }
    }
}

