/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UpdateRoleRequest;

public class UpdateRoleRequestMarshaller
implements Marshaller<Request<UpdateRoleRequest>, UpdateRoleRequest> {
    public Request<UpdateRoleRequest> marshall(UpdateRoleRequest updateRoleRequest) {
        if (updateRoleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateRoleRequest, "IamClient");
        request.addParameter("Action", "UpdateRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringConversion.fromString((String)updateRoleRequest.roleName()));
        }
        if (updateRoleRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)updateRoleRequest.description()));
        }
        if (updateRoleRequest.maxSessionDuration() != null) {
            request.addParameter("MaxSessionDuration", StringConversion.fromInteger((Integer)updateRoleRequest.maxSessionDuration()));
        }
        return request;
    }
}

