/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest;

public class UpdateAccountPasswordPolicyRequestMarshaller
implements Marshaller<Request<UpdateAccountPasswordPolicyRequest>, UpdateAccountPasswordPolicyRequest> {
    public Request<UpdateAccountPasswordPolicyRequest> marshall(UpdateAccountPasswordPolicyRequest updateAccountPasswordPolicyRequest) {
        if (updateAccountPasswordPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateAccountPasswordPolicyRequest, "IamClient");
        request.addParameter("Action", "UpdateAccountPasswordPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAccountPasswordPolicyRequest.minimumPasswordLength() != null) {
            request.addParameter("MinimumPasswordLength", StringConversion.fromInteger((Integer)updateAccountPasswordPolicyRequest.minimumPasswordLength()));
        }
        if (updateAccountPasswordPolicyRequest.requireSymbols() != null) {
            request.addParameter("RequireSymbols", StringConversion.fromBoolean((Boolean)updateAccountPasswordPolicyRequest.requireSymbols()));
        }
        if (updateAccountPasswordPolicyRequest.requireNumbers() != null) {
            request.addParameter("RequireNumbers", StringConversion.fromBoolean((Boolean)updateAccountPasswordPolicyRequest.requireNumbers()));
        }
        if (updateAccountPasswordPolicyRequest.requireUppercaseCharacters() != null) {
            request.addParameter("RequireUppercaseCharacters", StringConversion.fromBoolean((Boolean)updateAccountPasswordPolicyRequest.requireUppercaseCharacters()));
        }
        if (updateAccountPasswordPolicyRequest.requireLowercaseCharacters() != null) {
            request.addParameter("RequireLowercaseCharacters", StringConversion.fromBoolean((Boolean)updateAccountPasswordPolicyRequest.requireLowercaseCharacters()));
        }
        if (updateAccountPasswordPolicyRequest.allowUsersToChangePassword() != null) {
            request.addParameter("AllowUsersToChangePassword", StringConversion.fromBoolean((Boolean)updateAccountPasswordPolicyRequest.allowUsersToChangePassword()));
        }
        if (updateAccountPasswordPolicyRequest.maxPasswordAge() != null) {
            request.addParameter("MaxPasswordAge", StringConversion.fromInteger((Integer)updateAccountPasswordPolicyRequest.maxPasswordAge()));
        }
        if (updateAccountPasswordPolicyRequest.passwordReusePrevention() != null) {
            request.addParameter("PasswordReusePrevention", StringConversion.fromInteger((Integer)updateAccountPasswordPolicyRequest.passwordReusePrevention()));
        }
        if (updateAccountPasswordPolicyRequest.hardExpiry() != null) {
            request.addParameter("HardExpiry", StringConversion.fromBoolean((Boolean)updateAccountPasswordPolicyRequest.hardExpiry()));
        }
        return request;
    }
}

