/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;

public class PutRolePolicyRequestMarshaller
implements Marshaller<Request<PutRolePolicyRequest>, PutRolePolicyRequest> {
    public Request<PutRolePolicyRequest> marshall(PutRolePolicyRequest putRolePolicyRequest) {
        if (putRolePolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putRolePolicyRequest, "IamClient");
        request.addParameter("Action", "PutRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (putRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringConversion.fromString((String)putRolePolicyRequest.roleName()));
        }
        if (putRolePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)putRolePolicyRequest.policyName()));
        }
        if (putRolePolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringConversion.fromString((String)putRolePolicyRequest.policyDocument()));
        }
        return request;
    }
}

