/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyRequest;

public class PutGroupPolicyRequestMarshaller
implements Marshaller<Request<PutGroupPolicyRequest>, PutGroupPolicyRequest> {
    public Request<PutGroupPolicyRequest> marshall(PutGroupPolicyRequest putGroupPolicyRequest) {
        if (putGroupPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putGroupPolicyRequest, "IamClient");
        request.addParameter("Action", "PutGroupPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (putGroupPolicyRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)putGroupPolicyRequest.groupName()));
        }
        if (putGroupPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)putGroupPolicyRequest.policyName()));
        }
        if (putGroupPolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringConversion.fromString((String)putGroupPolicyRequest.policyDocument()));
        }
        return request;
    }
}

