/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;

public class ListGroupsRequestMarshaller
implements Marshaller<Request<ListGroupsRequest>, ListGroupsRequest> {
    public Request<ListGroupsRequest> marshall(ListGroupsRequest listGroupsRequest) {
        if (listGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listGroupsRequest, "IamClient");
        request.addParameter("Action", "ListGroups");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listGroupsRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringConversion.fromString((String)listGroupsRequest.pathPrefix()));
        }
        if (listGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listGroupsRequest.marker()));
        }
        if (listGroupsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listGroupsRequest.maxItems()));
        }
        return request;
    }
}

