/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;

public class ListAccessKeysRequestMarshaller
implements Marshaller<Request<ListAccessKeysRequest>, ListAccessKeysRequest> {
    public Request<ListAccessKeysRequest> marshall(ListAccessKeysRequest listAccessKeysRequest) {
        if (listAccessKeysRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listAccessKeysRequest, "IamClient");
        request.addParameter("Action", "ListAccessKeys");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listAccessKeysRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)listAccessKeysRequest.userName()));
        }
        if (listAccessKeysRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listAccessKeysRequest.marker()));
        }
        if (listAccessKeysRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listAccessKeysRequest.maxItems()));
        }
        return request;
    }
}

