/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest;

public class DeleteAccessKeyRequestMarshaller
implements Marshaller<Request<DeleteAccessKeyRequest>, DeleteAccessKeyRequest> {
    public Request<DeleteAccessKeyRequest> marshall(DeleteAccessKeyRequest deleteAccessKeyRequest) {
        if (deleteAccessKeyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteAccessKeyRequest, "IamClient");
        request.addParameter("Action", "DeleteAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAccessKeyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)deleteAccessKeyRequest.userName()));
        }
        if (deleteAccessKeyRequest.accessKeyId() != null) {
            request.addParameter("AccessKeyId", StringConversion.fromString((String)deleteAccessKeyRequest.accessKeyId()));
        }
        return request;
    }
}

