/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest;

public class CreateServiceSpecificCredentialRequestMarshaller
implements Marshaller<Request<CreateServiceSpecificCredentialRequest>, CreateServiceSpecificCredentialRequest> {
    public Request<CreateServiceSpecificCredentialRequest> marshall(CreateServiceSpecificCredentialRequest createServiceSpecificCredentialRequest) {
        if (createServiceSpecificCredentialRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createServiceSpecificCredentialRequest, "IamClient");
        request.addParameter("Action", "CreateServiceSpecificCredential");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServiceSpecificCredentialRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)createServiceSpecificCredentialRequest.userName()));
        }
        if (createServiceSpecificCredentialRequest.serviceName() != null) {
            request.addParameter("ServiceName", StringConversion.fromString((String)createServiceSpecificCredentialRequest.serviceName()));
        }
        return request;
    }
}

