/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;

public class CreateRoleRequestMarshaller
implements Marshaller<Request<CreateRoleRequest>, CreateRoleRequest> {
    public Request<CreateRoleRequest> marshall(CreateRoleRequest createRoleRequest) {
        if (createRoleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createRoleRequest, "IamClient");
        request.addParameter("Action", "CreateRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRoleRequest.path() != null) {
            request.addParameter("Path", StringConversion.fromString((String)createRoleRequest.path()));
        }
        if (createRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringConversion.fromString((String)createRoleRequest.roleName()));
        }
        if (createRoleRequest.assumeRolePolicyDocument() != null) {
            request.addParameter("AssumeRolePolicyDocument", StringConversion.fromString((String)createRoleRequest.assumeRolePolicyDocument()));
        }
        if (createRoleRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createRoleRequest.description()));
        }
        if (createRoleRequest.maxSessionDuration() != null) {
            request.addParameter("MaxSessionDuration", StringConversion.fromInteger((Integer)createRoleRequest.maxSessionDuration()));
        }
        if (createRoleRequest.permissionsBoundary() != null) {
            request.addParameter("PermissionsBoundary", StringConversion.fromString((String)createRoleRequest.permissionsBoundary()));
        }
        return request;
    }
}

