/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest;

public class CreateLoginProfileRequestMarshaller
implements Marshaller<Request<CreateLoginProfileRequest>, CreateLoginProfileRequest> {
    public Request<CreateLoginProfileRequest> marshall(CreateLoginProfileRequest createLoginProfileRequest) {
        if (createLoginProfileRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createLoginProfileRequest, "IamClient");
        request.addParameter("Action", "CreateLoginProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoginProfileRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)createLoginProfileRequest.userName()));
        }
        if (createLoginProfileRequest.password() != null) {
            request.addParameter("Password", StringConversion.fromString((String)createLoginProfileRequest.password()));
        }
        if (createLoginProfileRequest.passwordResetRequired() != null) {
            request.addParameter("PasswordResetRequired", StringConversion.fromBoolean((Boolean)createLoginProfileRequest.passwordResetRequired()));
        }
        return request;
    }
}

