/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest;

public class CreateAccessKeyRequestMarshaller
implements Marshaller<Request<CreateAccessKeyRequest>, CreateAccessKeyRequest> {
    public Request<CreateAccessKeyRequest> marshall(CreateAccessKeyRequest createAccessKeyRequest) {
        if (createAccessKeyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createAccessKeyRequest, "IamClient");
        request.addParameter("Action", "CreateAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAccessKeyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)createAccessKeyRequest.userName()));
        }
        return request;
    }
}

