/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadSshPublicKeyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UploadSshPublicKeyRequest> {
    private final String userName;
    private final String sshPublicKeyBody;

    private UploadSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyBody() {
        return this.sshPublicKeyBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyBody());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSshPublicKeyRequest)) {
            return false;
        }
        UploadSshPublicKeyRequest other = (UploadSshPublicKeyRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.sshPublicKeyBody(), other.sshPublicKeyBody());
    }

    public String toString() {
        return ToString.builder((String)"UploadSshPublicKeyRequest").add("UserName", (Object)this.userName()).add("SSHPublicKeyBody", (Object)this.sshPublicKeyBody()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyBody": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeyBody()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSshPublicKeyRequest model) {
            super(model);
            this.userName(model.userName);
            this.sshPublicKeyBody(model.sshPublicKeyBody);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyBody() {
            return this.sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final void setSSHPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadSshPublicKeyRequest build() {
            return new UploadSshPublicKeyRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, UploadSshPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyBody(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

