/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadServerCertificateRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UploadServerCertificateRequest> {
    private final String path;
    private final String serverCertificateName;
    private final String certificateBody;
    private final String privateKey;
    private final String certificateChain;

    private UploadServerCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.serverCertificateName = builder.serverCertificateName;
        this.certificateBody = builder.certificateBody;
        this.privateKey = builder.privateKey;
        this.certificateChain = builder.certificateChain;
    }

    public String path() {
        return this.path;
    }

    public String serverCertificateName() {
        return this.serverCertificateName;
    }

    public String certificateBody() {
        return this.certificateBody;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public String certificateChain() {
        return this.certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadServerCertificateRequest)) {
            return false;
        }
        UploadServerCertificateRequest other = (UploadServerCertificateRequest)((Object)obj);
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.serverCertificateName(), other.serverCertificateName()) && Objects.equals(this.certificateBody(), other.certificateBody()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.certificateChain(), other.certificateChain());
    }

    public String toString() {
        return ToString.builder((String)"UploadServerCertificateRequest").add("Path", (Object)this.path()).add("ServerCertificateName", (Object)this.serverCertificateName()).add("CertificateBody", (Object)this.certificateBody()).add("PrivateKey", (Object)this.privateKey()).add("CertificateChain", (Object)this.certificateChain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "ServerCertificateName": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateName()));
            }
            case "CertificateBody": {
                return Optional.ofNullable(clazz.cast(this.certificateBody()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String path;
        private String serverCertificateName;
        private String certificateBody;
        private String privateKey;
        private String certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadServerCertificateRequest model) {
            super(model);
            this.path(model.path);
            this.serverCertificateName(model.serverCertificateName);
            this.certificateBody(model.certificateBody);
            this.privateKey(model.privateKey);
            this.certificateChain(model.certificateChain);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getServerCertificateName() {
            return this.serverCertificateName;
        }

        @Override
        public final Builder serverCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        public final void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        public final String getCertificateBody() {
            return this.certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadServerCertificateRequest build() {
            return new UploadServerCertificateRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, UploadServerCertificateRequest> {
        public Builder path(String var1);

        public Builder serverCertificateName(String var1);

        public Builder certificateBody(String var1);

        public Builder privateKey(String var1);

        public Builder certificateChain(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

