/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSamlProviderRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UpdateSamlProviderRequest> {
    private final String samlMetadataDocument;
    private final String samlProviderArn;

    private UpdateSamlProviderRequest(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlProviderArn = builder.samlProviderArn;
    }

    public String samlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public String samlProviderArn() {
        return this.samlProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlProviderArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSamlProviderRequest)) {
            return false;
        }
        UpdateSamlProviderRequest other = (UpdateSamlProviderRequest)((Object)obj);
        return Objects.equals(this.samlMetadataDocument(), other.samlMetadataDocument()) && Objects.equals(this.samlProviderArn(), other.samlProviderArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSamlProviderRequest").add("SAMLMetadataDocument", (Object)this.samlMetadataDocument()).add("SAMLProviderArn", (Object)this.samlProviderArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLMetadataDocument": {
                return Optional.ofNullable(clazz.cast(this.samlMetadataDocument()));
            }
            case "SAMLProviderArn": {
                return Optional.ofNullable(clazz.cast(this.samlProviderArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String samlMetadataDocument;
        private String samlProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSamlProviderRequest model) {
            super(model);
            this.samlMetadataDocument(model.samlMetadataDocument);
            this.samlProviderArn(model.samlProviderArn);
        }

        public final String getSAMLMetadataDocument() {
            return this.samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final void setSAMLMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        public final String getSAMLProviderArn() {
            return this.samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final void setSAMLProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSamlProviderRequest build() {
            return new UpdateSamlProviderRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, UpdateSamlProviderRequest> {
        public Builder samlMetadataDocument(String var1);

        public Builder samlProviderArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

