/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AccessKeyMetadata;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model._accessKeyMetadataListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessKeysResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListAccessKeysResponse> {
    private final List<AccessKeyMetadata> accessKeyMetadata;
    private final Boolean isTruncated;
    private final String marker;

    private ListAccessKeysResponse(BuilderImpl builder) {
        super(builder);
        this.accessKeyMetadata = builder.accessKeyMetadata;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<AccessKeyMetadata> accessKeyMetadata() {
        return this.accessKeyMetadata;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessKeysResponse)) {
            return false;
        }
        ListAccessKeysResponse other = (ListAccessKeysResponse)((Object)obj);
        return Objects.equals(this.accessKeyMetadata(), other.accessKeyMetadata()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListAccessKeysResponse").add("AccessKeyMetadata", this.accessKeyMetadata()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyMetadata": {
                return Optional.ofNullable(clazz.cast(this.accessKeyMetadata()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<AccessKeyMetadata> accessKeyMetadata = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessKeysResponse model) {
            super(model);
            this.accessKeyMetadata(model.accessKeyMetadata);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<AccessKeyMetadata.Builder> getAccessKeyMetadata() {
            return this.accessKeyMetadata != null ? (Collection)this.accessKeyMetadata.stream().map(AccessKeyMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessKeyMetadata(Collection<AccessKeyMetadata> accessKeyMetadata) {
            this.accessKeyMetadata = _accessKeyMetadataListTypeCopier.copy(accessKeyMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeyMetadata(AccessKeyMetadata ... accessKeyMetadata) {
            this.accessKeyMetadata(Arrays.asList(accessKeyMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeyMetadata(Consumer<AccessKeyMetadata.Builder> ... accessKeyMetadata) {
            this.accessKeyMetadata(Stream.of(accessKeyMetadata).map(c -> (AccessKeyMetadata)((AccessKeyMetadata.Builder)AccessKeyMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessKeyMetadata(Collection<AccessKeyMetadata.BuilderImpl> accessKeyMetadata) {
            this.accessKeyMetadata = _accessKeyMetadataListTypeCopier.copyFromBuilder(accessKeyMetadata);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListAccessKeysResponse build() {
            return new ListAccessKeysResponse(this);
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    CopyableBuilder<Builder, ListAccessKeysResponse> {
        public Builder accessKeyMetadata(Collection<AccessKeyMetadata> var1);

        public Builder accessKeyMetadata(AccessKeyMetadata ... var1);

        public Builder accessKeyMetadata(Consumer<AccessKeyMetadata.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

