/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupDetail
implements ToCopyableBuilder<Builder, GroupDetail> {
    private final String path;
    private final String groupName;
    private final String groupId;
    private final String arn;
    private final Instant createDate;
    private final List<PolicyDetail> groupPolicyList;
    private final List<AttachedPolicy> attachedManagedPolicies;

    private GroupDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.groupPolicyList = builder.groupPolicyList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
    }

    public String path() {
        return this.path;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupId() {
        return this.groupId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public List<PolicyDetail> groupPolicyList() {
        return this.groupPolicyList;
    }

    public List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupPolicyList());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedManagedPolicies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupDetail)) {
            return false;
        }
        GroupDetail other = (GroupDetail)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.groupPolicyList(), other.groupPolicyList()) && Objects.equals(this.attachedManagedPolicies(), other.attachedManagedPolicies());
    }

    public String toString() {
        return ToString.builder((String)"GroupDetail").add("Path", (Object)this.path()).add("GroupName", (Object)this.groupName()).add("GroupId", (Object)this.groupId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("GroupPolicyList", this.groupPolicyList()).add("AttachedManagedPolicies", this.attachedManagedPolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "GroupPolicyList": {
                return Optional.ofNullable(clazz.cast(this.groupPolicyList()));
            }
            case "AttachedManagedPolicies": {
                return Optional.ofNullable(clazz.cast(this.attachedManagedPolicies()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String groupName;
        private String groupId;
        private String arn;
        private Instant createDate;
        private List<PolicyDetail> groupPolicyList = DefaultSdkAutoConstructList.getInstance();
        private List<AttachedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupDetail model) {
            this.path(model.path);
            this.groupName(model.groupName);
            this.groupId(model.groupId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.groupPolicyList(model.groupPolicyList);
            this.attachedManagedPolicies(model.attachedManagedPolicies);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<PolicyDetail.Builder> getGroupPolicyList() {
            return this.groupPolicyList != null ? (Collection)this.groupPolicyList.stream().map(PolicyDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupPolicyList(Collection<PolicyDetail> groupPolicyList) {
            this.groupPolicyList = _policyDetailListTypeCopier.copy(groupPolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupPolicyList(PolicyDetail ... groupPolicyList) {
            this.groupPolicyList(Arrays.asList(groupPolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupPolicyList(Consumer<PolicyDetail.Builder> ... groupPolicyList) {
            this.groupPolicyList(Stream.of(groupPolicyList).map(c -> (PolicyDetail)((PolicyDetail.Builder)PolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroupPolicyList(Collection<PolicyDetail.BuilderImpl> groupPolicyList) {
            this.groupPolicyList = _policyDetailListTypeCopier.copyFromBuilder(groupPolicyList);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            return this.attachedManagedPolicies != null ? (Collection)this.attachedManagedPolicies.stream().map(AttachedPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Stream.of(attachedManagedPolicies).map(c -> (AttachedPolicy)((AttachedPolicy.Builder)AttachedPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        public GroupDetail build() {
            return new GroupDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GroupDetail> {
        public Builder path(String var1);

        public Builder groupName(String var1);

        public Builder groupId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder groupPolicyList(Collection<PolicyDetail> var1);

        public Builder groupPolicyList(PolicyDetail ... var1);

        public Builder groupPolicyList(Consumer<PolicyDetail.Builder> ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);

        public Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... var1);
    }
}

